/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSMineshaftConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6834;
import net.minecraft.class_6880;

public class MineshaftStructure<C extends RSMineshaftConfig>
extends AdvancedJigsawStructure<C> {
    public MineshaftStructure(Codec<C> codec) {
        super(codec, MineshaftStructure::isMineshaftFeatureChunk, MineshaftStructure::generateMineshaftPieces);
    }

    public MineshaftStructure(Codec<C> codec, Predicate<class_6834.class_6835<C>> locationCheckPredicate, Function<class_6834.class_6835<C>, Optional<class_6622<C>>> pieceCreationPredicate) {
        super(codec, locationCheckPredicate, pieceCreationPredicate);
    }

    protected static <CC extends RSMineshaftConfig> boolean isMineshaftFeatureChunk(class_6834.class_6835<CC> context) {
        class_2919 worldgenRandom = new class_2919((class_5819)new class_5820(0L));
        worldgenRandom.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        double chance = ((RSMineshaftConfig)context.comp_310()).probability;
        if (worldgenRandom.nextDouble() >= chance) {
            return false;
        }
        class_6880 biomeAtSpot = context.comp_306().method_16359(class_5742.method_33100((int)context.comp_309().method_33940()), class_5742.method_33100((int)50), class_5742.method_33100((int)context.comp_309().method_33942()));
        return context.comp_312().test(biomeAtSpot) && AdvancedJigsawStructure.isAdvancedFeatureChunk(context);
    }

    public static <CC extends RSMineshaftConfig> Optional<class_6622<CC>> generateMineshaftPieces(class_6834.class_6835<CC> context) {
        int bottomClipOff;
        int topClipOff;
        class_2338.class_2339 blockpos = new class_2338.class_2339(context.comp_309().method_8326(), 0, context.comp_309().method_8328());
        RSMineshaftConfig config = (RSMineshaftConfig)context.comp_310();
        if (config.maxY - config.minY <= 0) {
            RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + ((class_5321)config.startPool.method_40230().get()).method_29177());
        }
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
        blockpos.method_10104(class_2350.field_11036, structureStartHeight);
        if (config.verticalRange.isEmpty()) {
            topClipOff = config.clipOutOfBoundsPieces ? config.maxY + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? config.minY - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + (Integer)config.verticalRange.get();
            bottomClipOff = structureStartHeight - (Integer)config.verticalRange.get();
        }
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.comp_314()), (class_2338)blockpos, false, false, topClipOff, bottomClipOff, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            int justBelowTerrain = MineshaftStructure.getTerrainHeight(context.comp_309().method_33943(0), context.comp_306(), context.comp_311()) - 15;
            int finalJustBelowTerrain = Math.max(justBelowTerrain, bottomClipOff);
            Optional<class_3790> topPiece = pieces.stream().max(Comparator.comparingInt(piece -> piece.method_14935().method_35419()));
            if (topPiece.isPresent() && finalJustBelowTerrain < topClipOff && finalJustBelowTerrain < topPiece.get().method_14935().method_35419()) {
                int topPieceMaxY = topPiece.get().method_14935().method_35419();
                pieces.forEach(piece -> piece.method_14922(0, finalJustBelowTerrain - topPieceMaxY, 0));
            }
        });
    }

    private static int getTerrainHeight(class_2338 centerPos, class_2794 chunkGenerator, class_5539 heightLimitView) {
        int height = chunkGenerator.method_18028(centerPos.method_10263(), centerPos.method_10260(), class_2902.class_2903.field_13195, heightLimitView);
        class_2338 pos = new class_2338(centerPos.method_10263(), GeneralUtils.getMaxTerrainLimit(chunkGenerator), centerPos.method_10260());
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)pos).method_10104(direction, 16);
            height = Math.min(height, chunkGenerator.method_18028(mutable.method_10263(), mutable.method_10260(), class_2902.class_2903.field_13195, heightLimitView));
        }
        return height;
    }
}

